function CorrFuncFig()

%   This is a part of the GNAT
%   Copyright  2024  <Mathias Nilsson>%
%   This program is free software; you can redistribute it and/or modify
%   it under the terms of the GNU General Public License as published by
%   the Free Software Foundation; either version 2 of the License, or
%   (at your option) any later version.
%
%   This program is distributed in the hope that it will be useful,
%   but WITHOUT ANY WARRANTY; without even the implied warranty of
%   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
%   GNU General Public License for more details.
%
%   You should have received a copy of the GNU General Public License along
%   with this program; if not, write to the Free Software Foundation, Inc.,
%   51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
%
%   Dr. Mathias Nilsson
%   School of Chemistry, University of Manchester,
%   Oxford Road, Manchester M13 9PL, UK
%   Telephone: +44 (0) 161 306 4465
%   Fax: +44 (0)161 275 4598
%
%   Hugo da Silva Rocha, PhD Student
%   School of Chemistry, University of Manchester,
%   hugo.rocha@postgrad.manchester.ac.uk
%   Telephone: +44 (0) 7871080481

%% ---------Setup the GUI
% GUIData.version=sprintf('%s plot analysis v 1.0',method);
hPLOTfigure = figure(...
    'Units','normalized',...
    'Name','',... 
    'MenuBar','none',...
    'NumberTitle','Off',...
    'Toolbar','Figure',...
    'OuterPosition',[0.0 0.0 0.55 0.6],...
    'Color','w',...
    'Tag','mainfigure',...
    'Visible','on');
movegui(hPLOTfigure,'center')
GUIData.MessageText={datestr(datetime)};

guidata(hPLOTfigure,GUIData);

% figure
% plot(real(1./corrfid))
% hold on
% plot(imag(1./corrfid))

%% 
% Clean up the Toolbar, removing things we don't need
    tmp = findall(hPLOTfigure,'ToolTipString','New Figure');
    set(tmp,'Visible','Off')
    tmp = findall(hPLOTfigure,'ToolTipString','Open File');
    set(tmp,'Visible','Off')
    tmp = findall(hPLOTfigure,'ToolTipString','Link Plot');
    set(tmp,'Visible','Off')
    tmp = findall(hPLOTfigure,'ToolTipString','Insert Legend');
    set(tmp,'Visible','off')
    tmp = findall(hPLOTfigure,'ToolTipString','Rotate 3D');
    set(tmp,'Visible','Off')
    tmp = findall(hPLOTfigure,'ToolTipString','Brush/Select Data');
    set(tmp,'Visible','Off')
    tmp = findall(hPLOTfigure,'ToolTipString','Insert Colorbar');
    set(tmp,'Visible','Off')
%---------- Main Tab
hTabGroup=uitabgroup(...
    'Parent',hPLOTfigure,...
    'Units','Normalized',...
    'Position',[0 0 1 1],...
    'visible','on');    
%% ---------PCA
hTabScoreLoadingResidual=uitab(...
    'Parent',hTabGroup,...
    'Title','Correction Function',...
    'TooltipString','Basic spectral analysis tools for PCA models',...
    'Units','Normalized');

%---------- Plot Panel
AxesSLRPanel=uipanel(...
    'Parent',hTabScoreLoadingResidual,...
    'Units','normalized',...
    'Position',[0.0 0.0 1 1],...
    'BackgroundColor',[1 1 1],...
    'Visible','on');
Axes = axes(...
    'Parent',AxesSLRPanel,...
    'Units','normalized',...
    'Visible','on',...
    'Box','off',...
    'tag','ax1',...
    'ylim',[-inf inf],...
    'Position',[0.11 0.2 0.85 0.65]);


% Checking if the Reference Deconvolution limits have been set
hMainFigure = findobj('Type','figure','Tag','MainFigure');
if ~isempty(hMainFigure)
    NmrData = guidata(hMainFigure(1));

    plot(gca,real(1./NmrData.corrfid(1)))
    hold on
    plot(gca,imag(1./NmrData.corrfid(1)))
end


end